// InteractionToolView.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "IB.h"
#include "MainFrm.h"
#include "InteractionToolView.h"
#include "IBFlowView.h"
#include "SpeechInputDlg.h"
#include "TouchInputDlg.h"
#include "SpeechInputDlg.h"
#include "TouchInputDlg.h"
#include "XISLHeadDlg.h"
#include "MMIBrowserOutputDlg.h"
#include "XISLInputTag.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CInteractionToolView

IMPLEMENT_DYNCREATE(CInteractionToolView, CFormView)

CInteractionToolView::CInteractionToolView()
	: CFormView(CInteractionToolView::IDD)
{
	//{{AFX_DATA_INIT(CInteractionToolView)
	//}}AFX_DATA_INIT
	bITViewActive = FALSE;
	pConnectDoc = NULL;
	m_strSelectName = "";
	m_strSelectObjPath = "";

	m_bReDrawView = TRUE;
	m_pSelectXISLTag = NULL;
}

CInteractionToolView::~CInteractionToolView()
{
	m_Font.DeleteObject();
}

void CInteractionToolView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInteractionToolView)
	DDX_Control(pDX, IDC_INTERACTION_TREE, m_treeInteraction);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CInteractionToolView, CFormView)
	//{{AFX_MSG_MAP(CInteractionToolView)
	ON_NOTIFY(TVN_SELCHANGED, IDC_INTERACTION_TREE, OnSelchangedInteractionTree)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
	ON_MESSAGE(MY_UPDATE_VIEW,OnUpdateView)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INTERACTION_TREE, OnCustomDraw)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CInteractionToolView ff

#ifdef _DEBUG
void CInteractionToolView::AssertValid() const
{
	CFormView::AssertValid();
}

void CInteractionToolView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}
#endif //_DEBUG


/////////////////////////////////////////////////////////////////////////////
// CInteractionToolView ̃\bh
/******************************************************************************************
 ֐		: void CInteractionToolView::SetConnectDoc(CXISLDoc *pDoc)
 @\		: r[Ɋ֘At
 		: CXISLDoc 
 ߂l		: Ȃ
 ******************************************************************************************/
void CInteractionToolView::SetConnectDoc(CXISLDoc *pDoc)
{
	pConnectDoc = pDoc;
	m_strSelectName = "";
}

//void CInteractionToolView::NotifySelect(LPCTSTR lpszSelectedPath)
//@\@FRec̑IIuWFNg̃pXC^NVɒʒm
//@FlpszSelectedPathFIĂIuWFNg̃pX
//ԂlFCXISLTag * : XISLIuWFNg̃|C^
void CInteractionToolView::NotifySelect(LPCTSTR lpszSelectedPath)
{
	if(pConnectDoc == NULL)
		return;

	POSITION pos = pConnectDoc->GetFirstViewPosition();
	CView* pView = pConnectDoc->GetNextView(pos);
	if (pView->IsKindOf(RUNTIME_CLASS(CIBFlowView)))
		((CIBFlowView*)pView)->SetSelectedPath(lpszSelectedPath);
	else
		ASSERT(NULL);
}

//void CInteractionToolView::NotifySelectForm(LPCTSTR lpszSelectedPath)
//@\@FRec̑ItH[IuWFNg̃pXC^NVɒʒm
//@FlpszSelectedPathFIĂIuWFNg̃pX
//ԂlFCXISLTag * : XISLIuWFNg̃|C^
void CInteractionToolView::NotifySelectForm(LPCTSTR lpszSelectedPath,LPCTSTR lpszFilePath)
{
	if(pConnectDoc == NULL)
		return;

	POSITION pos = pConnectDoc->GetFirstViewPosition();
	CView* pView = pConnectDoc->GetNextView(pos);
	if (pView->IsKindOf(RUNTIME_CLASS(CIBFlowView)))
		((CIBFlowView*)pView)->SetSelectedFormPath(lpszSelectedPath,lpszFilePath);
	else
		ASSERT(NULL);
}

//CXISLTag *CInteractionToolView::GetSelectedItemParam()
//@\@FݑIĂ鍀ڂlParam(XISLIuWFNg̃|C^)Ԃ
//@F
//ԂlFCXISLTag * : XISLIuWFNg̃|C^
CXISLTag *CInteractionToolView::GetSelectedItemParam()
{
	TVITEMA tvi;
	tvi.mask = TVIF_HANDLE | TVIF_PARAM;
	tvi.hItem = m_treeInteraction.GetSelectedItem();

	if(m_treeInteraction.GetItem(&tvi) == 0)
		return NULL;
	
	return (CXISLTag*)tvi.lParam;
}


//CXISLTag *CInteractionToolView::GetSelectedItemExchange()
//@\@FݑIĂ鍀ڂlParam(XISLIuWFNg̃|C^)Ԃ
//@F
//ԂlFCXISLTag * : XISLIuWFNg̃|C^
CXISLTag *CInteractionToolView::GetSelectedItemExchange()
{
	TVITEMA tvi;
	tvi.mask = TVIF_HANDLE | TVIF_PARAM;

	tvi.hItem = m_treeInteraction.GetSelectedItem();
	while(tvi.hItem != NULL)
	{
		tvi.hItem = m_treeInteraction.GetParentItem(tvi.hItem);

		m_treeInteraction.GetItem(&tvi);

		if(((CXISLTag*)tvi.lParam)->m_nTagType == ID_TAG_EXCHANGE)
			return (CXISLTag*)tvi.lParam;
	}

	return NULL;
}

//HTREEITEM CInteractionToolView::ReplaceTreeItem(HTREEITEM hTarget,HTREEITEM hParent)
//@\@Fw肵c[ڂړ
//@FHTREEITEM hTargetFړc[ACẽnh
//		FHTREEITEM hParentFړꏊ
//ԂlFHTREEITEM		Fړ̃nh
HTREEITEM CInteractionToolView::ReplaceTreeItem(HTREEITEM hTarget,HTREEITEM hParent)
{
	// Rs[ACȅTVITEM\̂Ɏ擾
	TVITEM tvItem,tvParent;

	tvItem.hItem = hTarget;
	tvItem.mask = TVIF_CHILDREN | TVIF_STATE | TVIF_PARAM |
		TVIF_HANDLE | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	m_treeInteraction.GetItem(&tvItem);

	tvParent.hItem = hParent;
	tvParent.mask = TVIF_PARAM | TVIF_HANDLE;
	m_treeInteraction.GetItem(&tvParent);

	// Rs[ACẽeLXgTVITEM\̂Ɏ擾
	CString strText = m_treeInteraction.GetItemText(hTarget);
	tvItem.cchTextMax = strText.GetLength();
	tvItem.pszText = (LPTSTR)(LPCTSTR)strText;

	// ACe}̃}XNݒ
	tvItem.mask = TVIF_STATE | TVIF_PARAM | TVIF_TEXT |
		TVIF_HANDLE | TVIF_IMAGE | TVIF_SELECTEDIMAGE;

	// TVINSERTSTRUCT\̂pӂAlݒ
	TVINSERTSTRUCT tvInsert;
	tvInsert.hParent = hParent;
	tvInsert.hInsertAfter = TVI_LAST;
	tvInsert.item = tvItem;

	// Rs[̐eACeɐVACe}
	HTREEITEM hRetItem = m_treeInteraction.InsertItem(&tvInsert);

	CXISLTag *pTag = (CXISLTag*)tvItem.lParam;
	pTag->m_htreeItem = hRetItem;
	pTag->m_pParentTag = (CXISLTag*)tvParent.lParam;;

	// Rs[ACeqꍇɂ͂Rs[Kv
	HTREEITEM hChild = m_treeInteraction.GetChildItem(hTarget);
	while( hChild )
	{
		ReplaceTreeItem(hChild, hRetItem);
		hChild = m_treeInteraction.GetNextSiblingItem(hChild);
	}

	return hRetItem;
}

/*
void CInteractionToolView::DrawExchangeFlow()
{
	int nX = 0;
	int nY = 0;
	int nWidth = 0;
	int nHeight = 0;
	//0:operation, 1:action
	int nMode=0;
	CRect rect,ellipseRect;
	m_pictFlow.GetClientRect(&rect);
	CDC *pPictDC = m_pictFlow.GetDC();

	nWidth = rect.Width();
	nHeight = rect.Height();
	CXISLTag *pTag = GetSelectedItemParam();
	if(pTag)
	{
		if(pTag->m_nTagType > ID_TAG_EXCHANGE)
			pTag = GetSelectedItemExchange();
		if(pTag->m_nTagType == ID_TAG_EXCHANGE)
		{
			CString strData = ((CXISLExchangeTag*)pTag)->GetExchangeString();
//			AfxMessageBox(strData);

			int nCount = ((CXISLExchangeTag*)pTag)->GetItemCount();
			int nBmWidth = nCount*(62+10)/2;
			int nBmHeight = nCount*(40+30);

			if(nBmWidth<nWidth)
				nBmWidth = nWidth;
			if(nBmHeight<nHeight)
				nBmHeight = nHeight;

			CDC MemDC;
			MemDC.CreateCompatibleDC(pPictDC);
		
			CBitmap EflowBMP;
			EflowBMP.CreateCompatibleBitmap(pPictDC,nBmWidth,nBmHeight);
			CBitmap *pOldBMP = MemDC.SelectObject(&EflowBMP);

			int nIndex = 1;
			int nFlag = 0;
			CString strParam = "";
			int nNext = strData.Find("|",nIndex);
			while(!strData.IsEmpty())
			{
				if(nNext == -1)
				{
					strParam = strData.Mid(nIndex,strData.GetLength()-nIndex);
					nFlag = 1;
				}
				else
					strParam = strData.Mid(nIndex,nNext-nIndex);

				if(strParam == XISL_TAG_NAME[ID_TAG_OPERATION])
				{
					CBrush brush, *pBrush;
					brush.CreateSolidBrush(RGB(255,0,0));
					pBrush = MemDC.SelectObject(&brush);
					MemDC.Ellipse(rect.Width()/2-5,nY,rect.Width()/2+5,nY+10);
					nY += 10;
					MemDC.SelectObject(pBrush);
					brush.DeleteObject();
					nMode = 0;
				}
				else if(strParam == XISL_TAG_NAME[ID_TAG_ACTION])
				{
					nMode = 1;
				}
				else
				{
					CDC ExcItemDC;
					ExcItemDC.CreateCompatibleDC(pPictDC);
					CBitmap ExcItemBMP;
					BITMAP bmp;
					
					if(nMode == 0)
					{
						if(strParam == XISL_INPUT_TYPE[ID_INPUTTYPE_TOUCH])
							ExcItemBMP.LoadBitmap(IDB_TOUCH);
						else if(strParam == XISL_INPUT_TYPE[ID_INPUTTYPE_SPEECH])
							ExcItemBMP.LoadBitmap(IDB_SPEECH);
						else if(strParam == XISL_INPUT_TYPE[ID_INPUTTYPE_KEYBOARD])
							ExcItemBMP.LoadBitmap(IDB_TOUCH);
						else if(strParam == XISL_INPUT_TYPE[ID_INPUTTYPE_TIMER])
							ExcItemBMP.LoadBitmap(IDB_TOUCH);
					}
					else if(nMode == 1)
					{
						if(strParam == XISL_ACTION_TYPE[XISL_ACTION_WINDOW])
							ExcItemBMP.LoadBitmap(IDB_WINDOW);
						else if(strParam == XISL_ACTION_TYPE[XISL_ACTION_AGENT])
							ExcItemBMP.LoadBitmap(IDB_AGENT);
						else if(strParam == XISL_ACTION_TYPE[XISL_ACTION_TTS])
							ExcItemBMP.LoadBitmap(IDB_TOUCH);
						else if(strParam == XISL_ACTION_TYPE[XISL_ACTION_TIMER])
							ExcItemBMP.LoadBitmap(IDB_TOUCH);
					}

					ExcItemBMP.GetBitmap(&bmp);


					//MemDC.PatBlt(0,0,rect.Width(),rect.Height(),WHITENESS);
					CBitmap *pOldBMP = ExcItemDC.SelectObject(&ExcItemBMP);
					MemDC.BitBlt(0,nY,bmp.bmWidth,bmp.bmHeight,&ExcItemDC,0,0,SRCCOPY);
					nY += bmp.bmHeight;
					nX = bmp.bmWidth/2;
					ExcItemDC.SelectObject(pOldBMP);

					CPen *pOldPen,linePen;
					linePen.CreatePen(PS_SOLID,3,RGB(255,0,0));
					pOldPen = MemDC.SelectObject(&linePen);
					nY += 2;
					MemDC.MoveTo(nX,nY);
					nY += 15;
					MemDC.LineTo(nX,nY);
					MemDC.LineTo(nX-5,nY-5);
					MemDC.MoveTo(nX,nY);
					MemDC.LineTo(nX+5,nY-5);
					nY += 2;
					ExcItemDC.DeleteDC();
					ExcItemBMP.DeleteObject();

					if(nFlag == 1)
					{
						break;
					}
				}
				nIndex = nNext+1;
				nNext = strData.Find("|",nIndex);
			}

			if(nY > rect.bottom)
			{
				SCROLLINFO sc;
				sc.fMask = SIF_RANGE | SIF_PAGE;
				sc.nMax = nY;
				sc.nMin = 0;
				sc.nPage = rect.bottom;
				m_scrollVerExc.EnableScrollBar();
				m_scrollVerExc.SetScrollInfo(&sc);
			}

			pPictDC->BitBlt(0,0,rect.Width(),rect.Height(),&MemDC,nHScrollPos,nVScrollPos,SRCCOPY);
			MemDC.SelectObject(pOldBMP);

			DeleteObject(EflowBMP);
			DeleteObject(MemDC);
			return;
		}
	}
	pPictDC->PatBlt(0,0,rect.Width(),rect.Height(),WHITENESS);
}
*/

/////////////////////////////////////////////////////////////////////////////
// CInteractionToolView bZ[W nh

void CInteractionToolView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if(bActivate)
		bITViewActive = TRUE;
	else
		bITViewActive = FALSE;

	CFormView::OnActivateView(bActivate, pActivateView, pDeactiveView);
}

LRESULT CInteractionToolView::OnUpdateView(WPARAM wParam,LPARAM lParam)
{
//	if(!bITViewActive) return 0;

	TRACE("InteractionToolViewOnUpdateViewĂ΂ꂽ\n");

	pConnectDoc = (CXISLDoc*)wParam;
	if(pConnectDoc)
	{
		if(pConnectDoc->RegistXISLTree(&m_treeInteraction))
			return 0;
	}

	m_pSelectXISLTag = NULL;
	m_treeInteraction.DeleteAllItems();

	return 0;
}

void CInteractionToolView::OnInitialUpdate() 
{
	CFormView::OnInitialUpdate();
	
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	SetScrollSizes(MM_TEXT,CSize(1,1));
	CRect rect;
	GetClientRect(&rect);
	int nTreeHeight = (int)(rect.Height()*0.6);
	int nPictHeight = rect.Height()-nTreeHeight;
	int nWidth = rect.Width();
	m_treeInteraction.MoveWindow(5,5,nWidth-5,nTreeHeight-5);

	if(m_Font.m_hObject != NULL)
		m_Font.DeleteObject();
	m_Font.CreatePointFont(90,"lr pSVbN");
	m_treeInteraction.SetFont(&m_Font);
	m_treeInteraction.SetTextColor(0xff0000);

	m_Imagelist.Create(IDB_TREEIMAGES, 16, 1, RGB(255,0,255));
	m_treeInteraction.SetImageList(&m_Imagelist,TVSIL_NORMAL);

	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();
}


void CInteractionToolView::OnSelchangedInteractionTree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	TVITEMA tvi;
	tvi.mask = TVIF_PARAM;
	tvi = pNMTreeView->itemNew;

	m_htreeSelect = tvi.hItem;
	m_pSelectXISLTag = (CXISLTag*)tvi.lParam;
	m_strSelectName = XISL_TAG_NAME[m_pSelectXISLTag->m_nTagType];
	*pResult = 0;

	//	DrawExchangeFlow();
	if(m_bReDrawView)
		pConnectDoc->UpdateAllViews(NULL,ID_VIEW_FLOW|ID_VIEW_INTERACTION);
	else
		m_bReDrawView = TRUE;
}

//JX^h[FڂƂ̕`
void CInteractionToolView::OnCustomDraw(NMHDR* pNMHDR, LRESULT* pResult)
{
	NMTVCUSTOMDRAW*  lpCustomDraw = (NMTVCUSTOMDRAW*)pNMHDR;

    if( lpCustomDraw->nmcd.dwDrawStage == CDDS_PREPAINT )
    {
        //  ACe`ł悤ɂ
        *pResult = CDRF_NOTIFYITEMDRAW;
        return;
    }
	//  ACe`悳鎞ɂɂ
    if( lpCustomDraw->nmcd.dwDrawStage == CDDS_ITEMPREPAINT )
    {
		int nItem = (int)lpCustomDraw->nmcd.lItemlParam; 
		if( nItem == -1)
		{
			//  eLXgFݒ
			lpCustomDraw->clrText = RGB(255,255,255);
			//  wiFݒ
			lpCustomDraw->clrTextBk = RGB(0,0,0);
		}
        *pResult = 0;
        return;
     }
    
    *pResult = 0;
}

void CInteractionToolView::OnSize(UINT nType, int cx, int cy) 
{
	CFormView::OnSize(nType, cx, cy);
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	if(m_treeInteraction)
	{
		CRect rect;
		GetClientRect(&rect);
		m_treeInteraction.MoveWindow(5,5,rect.Width()-10,rect.Height()-10);
	}

}

void CInteractionToolView::OnDraw(CDC* pDC)
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
//	DrawExchangeFlow();
	TRACE("CInteractionToolView::OnDraw\n");
}

/*
void CInteractionToolView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	
	CFormView::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CInteractionToolView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	CDC *pPictDC = m_pictFlow.GetDC();
	CRect rectPict;
	m_pictFlow.GetClientRect(&rectPict);

	BOOL bDraw;
	int nNowPos;

	nNowPos = m_scrollVerExc.GetScrollPos();
	bDraw = TRUE;
	switch(nSBCode)
	{
	case SB_TOP:
		nNowPos = 0;
		break;
	case SB_BOTTOM:
		nNowPos = 0;
		break;
	case SB_LINEDOWN:
		nNowPos += 1;
		break;
	case SB_LINEUP:
		nNowPos -= 1;
		break;
	case SB_PAGEDOWN:
		nNowPos += 10;
		break;
	case SB_PAGEUP:
		nNowPos -= 10;
		break;
	case SB_THUMBPOSITION:
		nNowPos = nPos;
		break;
//	case SB_THUMBTRACK:
//		nNowPos = nPos;
//		bDraw = FALSE;
//		break;
//	case SB_ENDSCROLL:
//		nNowPos = nPos;
//		break;
	}

//	if(nNowPos<0) nNowPos = 0;

	nVScrollPos = nNowPos;
	m_scrollVerExc.SetScrollPos(nNowPos);
//	if(bDraw)
	//	DrawExchangeFlow();
	
//	pPictDC->ScrollDC(0,-nPos,&rectPict,&rectPict,NULL,NULL);
	CFormView::OnVScroll(nSBCode, nPos, pScrollBar);
}
*/
